<?php

/**
 * @am_plugin_api 6.0
*/
class Am_Plugin_LoginMonitor extends Am_Plugin
{
    const PLUGIN_STATUS = self::STATUS_BETA;
    const PLUGIN_COMM = self::COMM_COMMERCIAL;
    const PLUGIN_REVISION = '6.3.29';

    protected $_configPrefix = 'misc.';

    static function getEtXml()
    {
        return <<<CUT
<table_data name="email_template">
    <row type="email_template">
        <field name="name">misc.login-monitor.notify_admin</field>
        <field name="email_template_layout_id">2</field>
        <field name="lang">en</field>
        <field name="format">text</field>
        <field name="subject">%site_title%: %user.login% log in to his account</field>
        <field name="txt">
User log in to his account.

Login: %user.login%
Name: %user.name_f% %user.name_l%
Email: %user.email%
Date/Time: %time|time%
        </field>
    </row>
</table_data>
CUT;
    }

    function onSetupEmailTemplateTypes(Am_Event $e)
    {
        $e->addReturn([
            'id' => 'misc.login-monitor.notify_admin',
            'title' => 'Notify Admin about User Login',
            'mailPeriodic' => Am_Mail::ADMIN_REQUESTED,
            'isAdmin' => true,
            'vars' => ['user', 'time' => 'Date/Time of Log in'],
        ], 'misc.login-monitor.notify_admin');
    }

    function _initSetupForm(Am_Form_Setup $form)
    {
        $form->setTitle(___('Login Monitor'));
        $form->addElement('email_checkbox', 'notify_admin')
            ->setLabel(___('Notify Admin after User Log in to His Account'));

        $form->addMagicSelect('user_groups', ['class' => 'am-combobox-fixed'])
            ->setLabel("Send only if user has (any)\nkeep empty to send for all")
            ->loadOptions($this->getAccessOptions())
            ->setJsOptions(<<<CUT
{
   callbackTitle: function(option) {
        switch (option.value.charAt(0)) {
            case 'p':
                return `Product: \${option.text}`;
            case 'c':
                return `Product Category: \${option.text}`;
            default:
                return `User Group: \${option.text}`;    
        } 
   }
}
CUT
);
    }

    function checkAccess(User $u)
    {
        if (empty($this->getConfig('user_groups'))) return true;

        [$groups, $products] = $this->splitAccess($this->getConfig('user_groups'));

        if ($groups && array_intersect($groups, $u->getGroups())) return true;
        if ($products && array_intersect($products, $u->getActiveProductIds())) return true;
    }

    function splitAccess($options)
    {
        $products = $groups = [];
        foreach ($options as $v) {
            if (substr($v, 0, 1) == 'p') {
                $products[] = substr($v, 1);
            } elseif (substr($v, 0, 1) == 'c') {
                $products[] = $v;
            } else {
                $groups[] = $v;
            }
        }

        $products = $this->getDi()->productTable->extractProductIds($products);

        return [$groups, $products];
    }

    function getAccessOptions()
    {
        $gOptions = $this->getDi()->userGroupTable->getOptions();
        $cOptions = [];
        foreach ($this->getDi()->productCategoryTable->getAdminSelectOptions() as $id => $title) {
            $cOptions['c' . $id] = $title;
        }
        $pOptions = [];
        foreach ($this->getDi()->productTable->getOptions() as $id => $title) {
            $pOptions['p' . $id] = $title;
        }

        if ($cOptions || $gOptions) {
            $options = [];
            if ($gOptions) {
                $options[___('User Groups')] = $gOptions;
            }
            if ($cOptions) {
                $options[___('Product Categories')] = $cOptions;
            }
            $options[___('Products')] = $pOptions;
        } else {
            $options = $pOptions;
        }

        return $options;
    }

    function onAuthAfterLogin(Am_Event_AuthAfterLogin $e)
    {
        if ($this->getConfig('notify_admin')) {
            if ($this->checkAccess($e->getUser())) {
                $et = Am_Mail_Template::load('misc.login-monitor.notify_admin');
                $et->setUser($e->getUser());
                $et->setTime(sqlTime('now'));
                $et->sendAdmin();
            }
        }
    }
}