<?php

class Am_Import_FieldUserLogin extends Am_Import_Field
{
    protected $isMustBeAssigned = false;

    protected function _buildForm(HTML_QuickForm2_Container $form)
    {
        $form->addElement('static', 'field_'.$this->getName())
            ->setLabel($this->getTitle())
            ->setContent(sprintf("<div>%s</div>", ___('Generated')));
    }

    public function getValue($lineParsed, $partialRecord = null)
    {
        /* @var $partialRecord User */
        if ($this->isAssigned())
        {
            return parent::getValue($lineParsed, $partialRecord);
        } else
        {
            if ($partialRecord)
            {
                $partialRecord->generateLogin();

                return $partialRecord->login;
            } else
            {
                return $this->getDi()->security->randomString(8);
            }
        }
    }

    public function setValueForRecord($record, $lineParsed)
    {
        //user already exists in database and found by email address
        //so we do not want to overwrite his login with autogenerated value but we
        //still use new value for login if it is fetched from file
        if (!$this->isAssigned() && @$record->login)
        {
            return;
        }
        parent::setValueForRecord($record, $lineParsed);
    }
}