<?php











// Function to read JSON file
function readJSON($filename) {
    $content = file_get_contents($filename);
    return json_decode($content, true);
}

// Function to write JSON file
function writeJSON($filename, $data) {
    $content = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($filename, $content);
}

// Default file paths
$authFilePath = 'account_1/auth.json';
$proxiesFilePath = 'proxies.json';
$authRequiredFilePath = 'account_1/auth.required';
$workingFilePath = 'working';

// Default values
$defaultAuth = readJSON($authFilePath);
$defaultProxies = readJSON($proxiesFilePath);

// Messages
$message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get values from form
    $updatedAuth = $_POST['auth'];
    $updatedProxies = $_POST['proxies'];

    // Validate JSON input
    if (!json_decode($updatedAuth) || !json_decode($updatedProxies)) {
        $message = 'Error: Invalid JSON input. Please check your input and try again.';
    } else {
        // Check if values have changed
        $authChanged = $defaultAuth != json_decode($updatedAuth, true);
        $proxiesChanged = $defaultProxies != json_decode($updatedProxies, true);

        if ($authChanged || $proxiesChanged) {
            // Save updated values to files
            if ($authChanged) {
                writeJSON($authFilePath, json_decode($updatedAuth, true));
            }
            if ($proxiesChanged) {
                writeJSON($proxiesFilePath, json_decode($updatedProxies, true));
            }

            // Handle checkbox 1
            if (isset($_POST['checkbox1'])) {
                touch($authRequiredFilePath); // Create auth.required file
                $message = 'Auth.required created successfully.';
            } else {
                if (file_exists($authRequiredFilePath)) {
                    unlink($authRequiredFilePath); // Remove auth.required file
                    $message = 'Auth.required removed successfully.';
                }
            }

            // Handle checkbox 2
            if (isset($_POST['checkbox2'])) {
                unlink($workingFilePath); // Create working file
                $message .= ' Working file Removed successfully.';
            } else {
                if (file_exists($workingFilePath)) {
                    unlink($workingFilePath); // Remove working file
                    $message .= ' Working file removed successfully.';
                }
            }

            // Display success message
            $message = 'Saved successfully. ' . $message;

            // Update default values for display
            $defaultAuth = readJSON($authFilePath);
            $defaultProxies = readJSON($proxiesFilePath);
        } else {
            $message = 'No changes detected.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage</title>
</head>
<body>
<style>
h2 {font-family:arial; font-weight:bold; color:#000;}    
.success {font-family:verdana; font-weight:bold; color:green; width:400px; border:1px solid #25D366; background-color:000; padding:20px; margin:20px;}   
#auth , #proxies {width:400px; font-family:verdana; height:80px; padding:20px; margin:20px;}
body {font-family:arial;}
</style>
    <h2>Manage Settings</h2>

    <?php if (!empty($message)): ?>
        <div style="color: green;" class="success"><?php echo $message; ?></div>
    <?php endif; ?>

    <form method="post" action="">
        <label for="auth">Auth:</label> </br>
        <textarea name="auth" id="auth"><?php echo json_encode($defaultAuth, JSON_PRETTY_PRINT); ?></textarea> </br>

        <label for="proxies">Proxies:</label> </br>
        <textarea name="proxies" id="proxies"><?php echo json_encode($defaultProxies, JSON_PRETTY_PRINT); ?></textarea></br>
</br>
        <label for="checkbox1">
            <input type="checkbox" name="checkbox1" id="checkbox1"> Create Auth
        </label>
</br>
        <label for="checkbox2">
            <input type="checkbox" name="checkbox2" id="checkbox2"> Remove working file
        </label>

        <br>

        <button type="submit">Save</button>
    </form>

</body>
</html>
