<?php

/**
 * this method is automatically accessible as
 *     http://example.com/amember/ahrefs/admin
 * all controllers with names starting with "admin" 
 * will automatically require admin login and you
 * have to define checkPermissions method in controller
 */
class Ahrefs_AdminController extends Am_Controller 
{
    public function checkAdminPermissions(Admin $admin)
    {
        return $admin->isSuper(); // only super-admins allowed to open this
    }
    
    function indexAction() {
        $GLOBALS['ahrefsResetAllUsersUrl'] = $resetAllUsersUrl = $this->getDi()->url('ahrefs/admin/reset-limit-counters');
        $GLOBALS['ahrefsResetUserUrl'] = $this->getDi()->url('ahrefs/admin/user-reset-limit-counters');
        $GLOBALS['ahrefsBackToUrl'] = urlencode($this->getDi()->url('ahrefs/admin'));

        //$this->view->headScript()->appendFile($this->view->_scriptJs('ngrid.js'))->appendScript('jQuery(function($){$(".grid-wrap").ngrid();});');
        // add query class to fetch records for grid
        $ds = new Am_Query($this->getDi()->userTable);

        // define the grid
        $grid = new Am_Grid_ReadOnly('_ahrefs', 'Ahrefs keywords explorer', $ds, $this->_request, $this->view);

        $filter = new Am_Grid_Filter_Text('User', 'login');
        $filter->initFilter($grid);
        $grid->setFilter($filter);
        // define fields
        $grid->addField('login', 'User')->setRenderFunction(function($r, $fn, $g, $fo){
            $resetAllUsersUrl = $GLOBALS['ahrefsResetAllUsersUrl'];
            $resetUserUrl = $GLOBALS['ahrefsResetUserUrl'];
            $backToUrl = $GLOBALS['ahrefsBackToUrl'];

            $resetAllContainer = <<<EOS
<div style="border: none; margin-bottom: 5px;" id="mco-reset-btn-container">
<a class="button" id="ahrefs-reset-btn" href="$resetAllUsersUrl">
Reset all counters >>
</a>
</div>
EOS;

            $htmlBlock = <<<EOS
<script type="text/javascript">
$(document).ready(function() {
    var resetButtonContainerId = $("#mco-reset-btn-container");
    if (resetButtonContainerId.length === 0) {
        var gridContainer = $(".am-grid-container");
        gridContainer.eq(0).before($('$resetAllContainer'));
    }
});
</script>
EOS;
            $link = <<<EOS
<a  class="ahrefs-user-reset-btn" id="ahrefs-user-$r->user_id" href="$resetUserUrl?user=$r->user_id&goto=$backToUrl" target="_top">
$r->login</a>
EOS;
            return "<td>$link $htmlBlock</td>";
        });
        $grid->addField('ahrefs_kw_exp_left_count', 'Keywords Left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_kw_exp_limit > 0 ? $r->ahrefs_kw_exp_limit : Am_Di::getInstance()->config->get('ahrefs.kw_exp_limit');
            
            $left = $limit;
        	$today = date('Y-m-d');
        	if($r->ahrefs_kw_exp_last_date==$today){
                $history = empty($r->ahrefs_kw_exp_history) ? [] : json_decode($r->ahrefs_kw_exp_history);
                $todayCount = count(json_decode($r->ahrefs_kw_exp_history, TRUE));
                $left = $limit - $todayCount;
        	}
            return sprintf('<td><strong>%s</strong></td>', $left);
        });
        
        $grid->addField('ahrefs_kw_exp_history', 'Keywords Today')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
        	$today = date('Y-m-d');
        	if($r->ahrefs_kw_exp_last_date==$today){
                $history = empty($r->ahrefs_kw_exp_history) ? [] : json_decode($r->ahrefs_kw_exp_history);
                $todayCount = count(json_decode($r->ahrefs_kw_exp_history, TRUE));
        	}
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_kw_exp_total_count', 'Keywords Total');
        $grid->addField('ahrefs_kw_exp_limit', 'Keywords Search Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.kw_exp_limit'));
        });
        $grid->addField('ahrefs_kw_exp_last_date', 'Keywords Last Search')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_kw_exp_last_date, 'd/m/Y'));
        });

        $grid->addField('ahrefs_kw_exp_serp_update_left_count', 'SERP update Left Count')->setRenderFunction(function($r, $fn, $g, $fo){
            $serpUpdateLimit = $r->ahrefs_kw_exp_serp_update_limit > 0 ? $r->ahrefs_kw_exp_serp_update_limit : Am_Di::getInstance()->config->get('ahrefs.kw_exp_serp_update_limit');

            $serpUpdateLeft = $serpUpdateLimit;
            $today = date('Y-m-d');
            if($r->ahrefs_kw_exp_serp_update_last_date==$today){
                $history = empty($r->ahrefs_kw_exp_serp_update_history) ? [] : json_decode($r->ahrefs_kw_exp_serp_update_history);
                $todayCount = count(json_decode($r->ahrefs_kw_exp_serp_update_history, TRUE));
                $serpUpdateLeft = $serpUpdateLimit - $todayCount;
            }
            return sprintf('<td><strong>%s</strong></td>', $serpUpdateLeft);
        });

        $grid->addField('ahrefs_kw_exp_serp_update_history', 'SERP update Today')->setRenderFunction(function($r, $fn, $g, $fo){
            $today_count = 0;
            $today = date('Y-m-d');
            if($r->ahrefs_kw_exp_serp_update_last_date==$today){
                $history = empty($r->ahrefs_kw_exp_serp_update_history) ? [] : json_decode($r->ahrefs_kw_exp_serp_update_history);
                $today_count = count(json_decode($r->ahrefs_kw_exp_serp_update_history, TRUE));
            }
            return sprintf('<td>%s</td>', $today_count);
        });
        $grid->addField('ahrefs_kw_exp_serp_update_total_count', 'SERP update Total');
        $grid->addField('ahrefs_kw_exp_serp_update_limit', 'SERP update Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.kw_exp_serp_update_limit'));
        });
        $grid->addField('ahrefs_kw_exp_serp_update_last_date', 'SERP Last update')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_kw_exp_serp_update_last_date, 'd/m/Y'));
        });

        $this->view->title = "Ahrefs Keywords explorer";

        //$this->view->content = $htmlBlock . $grid->render();
        //$this->view->content = $htmlBlock;

        // run grid actions wrapped to layout.phtml
        $grid->runWithLayout('admin/layout.phtml');

        //$this->view->display('admin/layout.phtml'); // lay it out to admin header/footer
    }

    function siteExplorerAction()
    {

        $GLOBALS['ahrefsResetAllUsersUrl'] = $resetAllUsersUrl = $this->getDi()->url('ahrefs/admin/reset-limit-counters');
        $GLOBALS['ahrefsResetUserUrl'] = $this->getDi()->url('ahrefs/admin/user-reset-limit-counters');
        $GLOBALS['ahrefsBackToUrl'] = urlencode($this->getDi()->url('ahrefs/admin/site-explorer'));

        //$this->view->headScript()->appendFile($this->view->_scriptJs('ngrid.js'))->appendScript('jQuery(function($){$(".grid-wrap").ngrid();});');
        // add query class to fetch records for grid
        $ds = new Am_Query($this->getDi()->userTable);

        // define the grid
        $grid = new Am_Grid_ReadOnly('_ahrefs', 'Ahrefs site explorer', $ds, $this->_request, $this->view);

        $filter = new Am_Grid_Filter_Text('User', 'login');
        $filter->initFilter($grid);
        $grid->setFilter($filter);
        // define fields
        $grid->addField('login', 'User')->setRenderFunction(function($r, $fn, $g, $fo){
            $resetAllUsersUrl = $GLOBALS['ahrefsResetAllUsersUrl'];
            $resetUserUrl = $GLOBALS['ahrefsResetUserUrl'];
            $backToUrl = $GLOBALS['ahrefsBackToUrl'];

            $resetAllContainer = <<<EOS
<div style="border: none; margin-bottom: 5px;" id="mco-reset-btn-container">
<a class="button" id="ahrefs-reset-btn" href="$resetAllUsersUrl">
Reset all counters >>
</a>
</div>
EOS;

            $htmlBlock = <<<EOS
<script type="text/javascript">
$(document).ready(function() {
    var resetButtonContainerId = $("#mco-reset-btn-container");
    if (resetButtonContainerId.length === 0) {
        var gridContainer = $(".am-grid-container");
        gridContainer.eq(0).before($('$resetAllContainer'));
    }
});
</script>
EOS;

            $link = <<<EOS
<a  class="ahrefs-user-reset-btn" id="ahrefs-user-$r->user_id" href="$resetUserUrl?user=$r->user_id&goto=$backToUrl" target="_top">
$r->login</a>
EOS;
            return "<td>$link $htmlBlock</td>";
        });
        $grid->addField('ahrefs_site_exp_left_count', 'Search Left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_site_exp_limit > 0 ? $r->ahrefs_site_exp_limit : Am_Di::getInstance()->config->get('ahrefs.kw_exp_limit');

            $left = $limit;
            $today = date('Y-m-d');
            if($r->ahrefs_site_exp_last_date==$today){
                $history = empty($r->ahrefs_site_exp_history) ? [] : json_decode($r->ahrefs_site_exp_history);
                $todayCount = count(json_decode($r->ahrefs_site_exp_history, TRUE));
                $left = $limit - $todayCount;
            }
            return sprintf('<td><strong>%s</strong></td>', $left);
        });

        $grid->addField('ahrefs_site_exp_history', 'Today\'s searches')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
            $today = date('Y-m-d');
            if($r->ahrefs_site_exp_last_date==$today){
                $history = empty($r->ahrefs_site_exp_history) ? [] : json_decode($r->ahrefs_site_exp_history);
                $todayCount = count(json_decode($r->ahrefs_site_exp_history, TRUE));
            }
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_site_exp_total_count', 'Max Searches');
        $grid->addField('ahrefs_site_exp_limit', 'Search Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.kw_exp_limit'));
        });
        $grid->addField('ahrefs_site_exp_last_date', 'Last Search')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_site_exp_last_date, 'd/m/Y'));
        });


        $grid->addField('ahrefs_site_exp_url_prefix_left_count', 'URL prefix left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_site_exp_url_prefix_limit > 0 ? $r->ahrefs_site_exp_url_prefix_limit : Am_Di::getInstance()->config->get('ahrefs.site_exp_url_prefix_limit');

            $left = $limit;
            $today = date('Y-m-d');
            if($r->ahrefs_site_exp_url_prefix_last_date==$today){
                $history = empty($r->ahrefs_site_exp_url_prefix_history) ? [] : json_decode($r->ahrefs_site_exp_url_prefix_history);
                $todayCount = count(json_decode($r->ahrefs_site_exp_url_prefix_history, TRUE));
                $left = $limit - $todayCount;
            }
            return sprintf('<td><strong>%s</strong></td>', $left);
        });

        $grid->addField('ahrefs_site_exp_url_prefix_history', 'Today\'s URL prefix')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
            $today = date('Y-m-d');
            if($r->ahrefs_site_exp_url_prefix_last_date==$today){
                $history = empty($r->ahrefs_site_exp_url_prefix_history) ? [] : json_decode($r->ahrefs_site_exp_url_prefix_history);
                $todayCount = count(json_decode($r->ahrefs_site_exp_url_prefix_history, TRUE));
            }
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_site_exp_url_prefix_total_count', 'URL prefix Total');
        $grid->addField('ahrefs_site_exp_url_prefix_limit', 'URL prefix Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.site_exp_url_prefix_limit'));
        });
        $grid->addField('ahrefs_site_exp_url_prefix_last_date', 'URL prefix Last use')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_site_exp_url_prefix_last_date, 'd/m/Y'));
        });


        $grid->addField('ahrefs_site_exp_row_export_left_count', 'Row export left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_site_exp_row_export_limit > 0 ? $r->ahrefs_site_exp_row_export_limit : Am_Di::getInstance()->config->get('ahrefs.site_exp_row_export_limit');

            $left = $limit;
            $today = date('Y-m-d');
            if($r->ahrefs_site_exp_row_export_last_date==$today){
                $history = empty($r->ahrefs_site_exp_row_export_history) ? [] : json_decode($r->ahrefs_site_exp_row_export_history);
                $todayCount = count(json_decode($r->ahrefs_site_exp_row_export_history, TRUE));
                $left = $limit - $todayCount;
            }
            return sprintf('<td><strong>%s</strong></td>', $left);
        });

        $grid->addField('ahrefs_site_exp_row_export_history', 'Today\'s row export')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
            $today = date('Y-m-d');
            if($r->ahrefs_site_exp_row_export_last_date==$today){
                $history = empty($r->ahrefs_site_exp_row_export_history) ? [] : json_decode($r->ahrefs_site_exp_row_export_history);
                $todayCount = count(json_decode($r->ahrefs_site_exp_row_export_history, TRUE));
            }
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_site_exp_row_export_total_count', 'Row export Total');
        $grid->addField('ahrefs_site_exp_row_export_limit', 'URL prefix Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.site_exp_url_prefix_limit'));
        });
        $grid->addField('ahrefs_site_exp_row_export_last_date', 'Last row export')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_site_exp_row_export_last_date, 'd/m/Y'));
        });

        $this->view->title = "Ahrefs Site explorer";

        //$this->view->content = $htmlBlock . $grid->render();
        //$this->view->content = $htmlBlock;

        // run grid actions wrapped to layout.phtml
        $grid->runWithLayout('admin/layout.phtml');

        //$this->view->display('admin/layout.phtml'); // lay it out to admin header/footer
    }


    function contentExplorerAction() {
        $GLOBALS['ahrefsResetAllUsersUrl'] = $resetAllUsersUrl = $this->getDi()->url('ahrefs/admin/reset-limit-counters');
        $GLOBALS['ahrefsResetUserUrl'] = $this->getDi()->url('ahrefs/admin/user-reset-limit-counters');
        $GLOBALS['ahrefsBackToUrl'] = urlencode($this->getDi()->url('ahrefs/admin/content-explorer'));

        //$this->view->headScript()->appendFile($this->view->_scriptJs('ngrid.js'))->appendScript('jQuery(function($){$(".grid-wrap").ngrid();});');
        // add query class to fetch records for grid
        $ds = new Am_Query($this->getDi()->userTable);

        // define the grid
        $grid = new Am_Grid_ReadOnly('_ahrefs', 'Ahrefs Content Explorer', $ds, $this->_request, $this->view);

        $filter = new Am_Grid_Filter_Text('User', 'login');
        $filter->initFilter($grid);
        $grid->setFilter($filter);
        // define fields
        $grid->addField('login', 'User')->setRenderFunction(function($r, $fn, $g, $fo){
            $resetAllUsersUrl = $GLOBALS['ahrefsResetAllUsersUrl'];
            $resetUserUrl = $GLOBALS['ahrefsResetUserUrl'];
            $backToUrl = $GLOBALS['ahrefsBackToUrl'];

            $resetAllContainer = <<<EOS
<div style="border: none; margin-bottom: 5px;" id="mco-reset-btn-container">
<a class="button" href="$resetAllUsersUrl">
Reset all counters >>
</a>
</div>
EOS;

            $htmlBlock = <<<EOS
<script type="text/javascript">
$(document).ready(function() {
    var resetButtonContainerId = $("#mco-reset-btn-container");
    if (resetButtonContainerId.length === 0) {
        var gridContainer = $(".am-grid-container");
        gridContainer.eq(0).before($('$resetAllContainer'));
    }
});
</script>
EOS;
            $link = <<<EOS
<a  class="ahrefs-user-reset-btn" id="ahrefs-user-$r->user_id" href="$resetUserUrl?user=$r->user_id&goto=$backToUrl" target="_top">
$r->login</a>
EOS;
            return "<td>$link $htmlBlock</td>";
        });
        $grid->addField('ahrefs_content_exp_left_count', 'Topics Left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_content_exp_limit > 0 ? $r->ahrefs_content_exp_limit : Am_Di::getInstance()->config->get('ahrefs.content_exp_limit');

            $left = $limit;
            $today = date('Y-m-d');
            if($r->ahrefs_content_exp_last_date==$today){
                $history = empty($r->ahrefs_content_exp_history) ? [] : json_decode($r->ahrefs_content_exp_history);
                $todayCount = count(json_decode($r->ahrefs_content_exp_history, TRUE));
                $left = $limit - $todayCount;
            }
            return sprintf('<td><strong>%s</strong></td>', $left);
        });

        $grid->addField('ahrefs_content_exp_history', 'Topics used today')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
            $today = date('Y-m-d');
            if($r->ahrefs_content_exp_last_date==$today){
                $history = empty($r->ahrefs_content_exp_history) ? [] : json_decode($r->ahrefs_content_exp_history);
                $todayCount = count(json_decode($r->ahrefs_content_exp_history, TRUE));
            }
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_content_exp_total_count', 'Topics Total');
        $grid->addField('ahrefs_content_exp_limit', 'Topics Search Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.kw_exp_limit'));
        });
        $grid->addField('ahrefs_content_exp_last_date', 'Topics Last date')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_content_exp_last_date, 'd/m/Y'));
        });

        $this->view->title = "Ahrefs Content explorer";

        //$this->view->content = $htmlBlock . $grid->render();
        //$this->view->content = $htmlBlock;

        // run grid actions wrapped to layout.phtml
        $grid->runWithLayout('admin/layout.phtml');

        //$this->view->display('admin/layout.phtml'); // lay it out to admin header/footer
    }

    function newProjectAction() {
        $GLOBALS['ahrefsResetAllUsersUrl'] = $resetAllUsersUrl = $this->getDi()->url('ahrefs/admin/reset-limit-counters');
        $GLOBALS['ahrefsResetUserUrl'] = $this->getDi()->url('ahrefs/admin/user-reset-limit-counters');
        $GLOBALS['ahrefsBackToUrl'] = urlencode($this->getDi()->url('ahrefs/admin/new-project'));

        //$this->view->headScript()->appendFile($this->view->_scriptJs('ngrid.js'))->appendScript('jQuery(function($){$(".grid-wrap").ngrid();});');
        // add query class to fetch records for grid
        $ds = new Am_Query($this->getDi()->userTable);

        // define the grid
        $grid = new Am_Grid_ReadOnly('_ahrefs', 'Ahrefs Projects', $ds, $this->_request, $this->view);

        $filter = new Am_Grid_Filter_Text('User', 'login');
        $filter->initFilter($grid);
        $grid->setFilter($filter);
        // define fields
        $grid->addField('login', 'User')->setRenderFunction(function($r, $fn, $g, $fo){
            $resetAllUsersUrl = $GLOBALS['ahrefsResetAllUsersUrl'];
            $resetUserUrl = $GLOBALS['ahrefsResetUserUrl'];
            $backToUrl = $GLOBALS['ahrefsBackToUrl'];

            $resetAllContainer = <<<EOS
<div style="border: none; margin-bottom: 5px;" id="mco-reset-btn-container">
<a class="button" id="ahrefs-reset-btn" href="$resetAllUsersUrl">
Reset all counters >>
</a>
</div>
EOS;

            $htmlBlock = <<<EOS
<script type="text/javascript">
$(document).ready(function() {
    var resetButtonContainerId = $("#mco-reset-btn-container");
    if (resetButtonContainerId.length === 0) {
        var gridContainer = $(".am-grid-container");
        gridContainer.eq(0).before($('$resetAllContainer'));
    }
});
</script>
EOS;
            $link = <<<EOS
<a  class="ahrefs-user-reset-btn" href="$resetUserUrl?user=$r->user_id&goto=$backToUrl" target="_top">
$r->login</a>
EOS;
            return "<td>$link $htmlBlock</td>";
        });
        $grid->addField('ahrefs_new_project_left_count', 'Projects Left')->setRenderFunction(function($r, $fn, $g, $fo){
            $limit = $r->ahrefs_new_project_limit > 0 ? $r->ahrefs_new_project_limit : Am_Di::getInstance()->config->get('ahrefs.new_project_limit');

            $left = $limit;
            $today = date('Y-m-d');
            if($r->ahrefs_new_project_last_date==$today){
                $history = empty($r->ahrefs_new_project_history) ? [] : json_decode($r->ahrefs_new_project_history);
                $todayCount = count(json_decode($r->ahrefs_new_project_history, TRUE));
                $left = $limit - $todayCount;
            }
            return sprintf('<td><strong>%s</strong></td>', $left);
        });

        $grid->addField('ahrefs_new_project_history', 'Projects created today')->setRenderFunction(function($r, $fn, $g, $fo){
            $todayCount = 0;
            $today = date('Y-m-d');
            if($r->ahrefs_new_project_last_date==$today){
                $history = empty($r->ahrefs_new_project_history) ? [] : json_decode($r->ahrefs_new_project_history);
                $todayCount = count(json_decode($r->ahrefs_new_project_history, TRUE));
            }
            return sprintf('<td>%s</td>', $todayCount);
        });
        $grid->addField('ahrefs_new_project_total_count', 'Projects Total');
        $grid->addField('ahrefs_new_project_limit', 'Projects Limit')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td><strong>%s</strong></td>', Am_Di::getInstance()->config->get('ahrefs.kw_exp_limit'));
        });
        $grid->addField('ahrefs_new_project_last_date', 'Projects Last date')->setRenderFunction(function($r, $fn, $g, $fo){
            return sprintf('<td>%s</td>', date_format($r->ahrefs_new_project_last_date, 'd/m/Y'));
        });

        $this->view->title = "Ahrefs Projects";

        //$this->view->content = $htmlBlock . $grid->render();
        //$this->view->content = $htmlBlock;

        // run grid actions wrapped to layout.phtml
        $grid->runWithLayout('admin/layout.phtml');

        //$this->view->display('admin/layout.phtml'); // lay it out to admin header/footer
    }


    function resetLimitCountersAction()
    {
        $sqlStmt = <<<EOS
UPDATE ?_user SET ahrefs_kw_exp_history = ?, ahrefs_kw_exp_last_date = ?, ahrefs_kw_exp_total_count = ?,
ahrefs_kw_exp_serp_update_history = ?, ahrefs_kw_exp_serp_update_last_date = ?, ahrefs_kw_exp_serp_update_total_count = ?,
ahrefs_site_exp_history = ?, ahrefs_site_exp_last_date = ?, ahrefs_site_exp_total_count = ?,
ahrefs_site_exp_url_prefix_history = ?, ahrefs_site_exp_url_prefix_last_date = ?, ahrefs_site_exp_url_prefix_total_count = ?,
ahrefs_site_exp_row_export_history = ?, ahrefs_site_exp_row_export_last_date = ?, ahrefs_site_exp_row_export_total_count = ?,
ahrefs_content_exp_history = ?, ahrefs_content_exp_last_date = ?, ahrefs_content_exp_total_count = ?,
ahrefs_new_project_history = ?, ahrefs_new_project_last_date = ?, ahrefs_new_project_total_count = ?
EOS;

        $users = $this->getDi()->db->query($sqlStmt,
            json_encode([]), null, 0,
            json_encode([]), null, 0,
            json_encode([]), null, 0,
            json_encode([]), null, 0,
            json_encode([]), null, 0,
            json_encode([]), null, 0,
            json_encode([]), null, 0);
        $redirectUrl = $this->getDi()->url('ahrefs/admin');
        if (isset($_GET['goto']) && is_string($_GET['goto']))
            $redirectUrl = urldecode($_GET['goto']);
        header("Location: $redirectUrl");
        exit;
    }


    function userResetLimitCountersAction()
    {
        $sqlStmt = <<<EOS
UPDATE ?_user SET ahrefs_kw_exp_history = ?, ahrefs_kw_exp_last_date = ?, ahrefs_kw_exp_total_count = ?,
ahrefs_kw_exp_serp_update_history = ?, ahrefs_kw_exp_serp_update_last_date = ?, ahrefs_kw_exp_serp_update_total_count = ?,
ahrefs_site_exp_history = ?, ahrefs_site_exp_last_date = ?, ahrefs_site_exp_total_count = ?,
ahrefs_site_exp_url_prefix_history = ?, ahrefs_site_exp_url_prefix_last_date = ?, ahrefs_site_exp_url_prefix_total_count = ?,
ahrefs_site_exp_row_export_history = ?, ahrefs_site_exp_row_export_last_date = ?, ahrefs_site_exp_row_export_total_count = ?,
ahrefs_content_exp_history = ?, ahrefs_content_exp_last_date = ?, ahrefs_content_exp_total_count = ?,
ahrefs_new_project_history = ?, ahrefs_new_project_last_date = ?, ahrefs_new_project_total_count = ? WHERE user_id = ?
EOS;
        if (isset($_GET["user"]) && is_string($_GET["user"])) {
            $users = $this->getDi()->db->query($sqlStmt,
                json_encode([]), null, 0,
                json_encode([]), null, 0,
                json_encode([]), null, 0,
                json_encode([]), null, 0,
                json_encode([]), null, 0,
                json_encode([]), null, 0,
                json_encode([]), null, 0,$_GET["user"]);
        }

        $redirectUrl = $this->getDi()->url('ahrefs/admin');
        if (isset($_GET['goto']) && is_string($_GET['goto']))
            $redirectUrl = urldecode($_GET['goto']);
        header("Location: $redirectUrl");
        exit;
    }

    function createForm()
    {
        $form = new Am_Form;
        $form->addText('user_id', 'size=60')->setLabel("Name")->addRule('required');
        $form->addText('last_date', 'size=60')->setLabel("Name")->addRule('required');
        $form->addText('left_count', 'size=60')->setLabel("Left Count")->addRule('required');
        $form->addText('total_count', 'size=60')->setLabel("Total Count")->addRule('required');
        $form->addText('targets', 'size=60')->setLabel("Targets")->addRule('required');
        return $form;
    }
}