<?php

/**
 * This class is a sample how to work with aMember Am_Record and Am_Table
 * classes
 * It is better to use Am_Grid instead, but we are keeping it simple in this ahrefs
 */
class Ahrefs_DaoController extends Am_Controller
{
    /** @var AhrefsTable */
    protected $table;
    
    /**
     * This method is executed before any action
     * you can do common actions here.
     * if you throw an exception from this point, other methods will not be executed
     */
    public function preDispatch()
    {
        parent::preDispatch();
        // once you access Am_Di->somethingTable it will automatically look
        // corresponding table class and creates singleton for it
        $this->table = $this->getDi()->ahrefsTable;
    }

    function indexAction()
    {
        // now we will fetch all records from the table
        $records = $this->table->findBy(array()); // just select all records without filtering


        echo "<table border=1>";
        echo "<tr><th>Id</th><th>Title</th><th>Comment</th><th>&nbsp;</th></tr>\n";
        $root = REL_ROOT_URL . "/ahrefs/dao";
        foreach ($records as $record)
        {
            /* @var $record Ahrefs */
            echo "<tr>";
            echo "<td>" . $record->user_id . "</td>";
            echo "<td>" . Am_Controller::escape($record->last_date) . "</td>";
            echo "<td>" . Am_Controller::escape($record->left_count) . "</td>";
            echo "<td><a href='$root/delete?id={$record->total_count}'>Delete</a></td>";
            echo "</tr>\n";
        }
        echo "</table>";
        echo "<a href='$root/insert'>Insert new record</a>";
    }

    function insertAction()
    {
        // how to insert new record:
        /* @var $ahrefs Ahrefs */
        $ahrefs = $this->table->createRecord();
        $ahrefs->user_id = md5(rand());
        $ahrefs->last_date = sha1(rand());
        $ahrefs->left_count = 1;
        $ahrefs->total_count = 1;
        $ahrefs->targets = 1;
        $ahrefs->insert(); // or call $ahrefs->save();
        // how to edit record
        // $ahrefs->title = $ahrefs->title . '-XX';
        // $ahrefs->update(); // or call $ahrefs->save();
        $this->_redirect('ahrefs/dao');
    }
    
    function deleteAction()
    {
        $id = $this->_request->getInt('user_id');
        // or you may use
        // $this->_request->getFiltered('id'); for alphanumeric strings
        // $this->_request->get('id'); to get raw unfiltered input
        if (!$id)
            throw new Am_Exception_InputError("Empty user_id"); 
        // other types of exceptions logs an error, Am_Exception_InputError does not
        $ahrefs = $this->table->load($id); // will throw an exception if not found
        $ahrefs->delete();
        $this->_redirect('ahrefs/dao');
    }
    function sample()
    {
        // there are other sample usages:
        // returns array of Example objects
        $records = $this->table->findBy(array('title' => 'XX')); // AND
        // returns single Example object or null
        $record = $this->table->findFirstBy(array('example_id' => '11', 'title' => 'XX')); // AND
        //
        $this->table->deleteBy(array('comment' => 'XX'));
        // returns array of Example objects
        $records = $this->table->selectObjects("SELECT * FROM ?_example WHERE example_id>2");
        
        // single-record operations
        $example = $this->table->load(1, false); // false to do not throw exception if not found
        if (!$example) return;
        $example->title = 'XX'; // change title and save
        $example->save(); 
        $example->pk(); // get primary key - example_id for this object
        $example->updateQuick('title', 'YY'); // run UPDATE am_example title='YY' WHERE example_id=1
        $example->delete(); // delete the object
        // create new object
        $example = $this->table->createRecord();
        $example->title = 'xx';
        $example->comment = 'aa';
        $example->insert();
    }
}