<?php

// Define file paths
$jsonFile = 'proxies.json';

// Function to load JSON data from file
function loadProxies() {
    global $jsonFile;
    $jsonData = file_get_contents($jsonFile);
    return json_decode($jsonData, true);
}

// Function to save JSON data to file
function saveProxies($data) {
    global $jsonFile;
    $jsonData = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($jsonFile, $jsonData);
}

// Load proxies data
$proxies = loadProxies();

// Check if form submitted for modification
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ensure submitted data is JSON format
    $submittedData = json_decode($_POST['proxies'], true);
    
    // Check if JSON data is valid
    if ($submittedData !== null) {
        // Update proxies data with submitted data
        $proxies = $submittedData;
        // Save updated data
        saveProxies($proxies);
    } else {
        // Invalid JSON data submitted
        echo "Invalid JSON data submitted!";
        exit;
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proxies</title>
</head>
<body>
    <h1>Proxies</h1>
    
    <h2>Current Proxies</h2>
    <pre><?php echo json_encode($proxies, JSON_PRETTY_PRINT); ?></pre>
    
    <h2>Modify Proxies</h2>
    <form method="POST">
        <textarea name="proxies" rows="10" cols="50"><?php echo json_encode($proxies, JSON_PRETTY_PRINT); ?></textarea>
        <br>
        <input type="submit" value="Save">
    </form>
</body>
</html>
